/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
  

 /**
 * \file    uart_loopback_test.c
 *
 * \brief   This file contains support routines to test uart. 
 *
 * This file contains support routines to test uart 
 * 
 *
 * \author  0043
 *
 * \version 01a,13aug,2010 Created
 */

#include "uart.h"
#include "stdio.h"
#include "string.h"
#ifdef REDEFINE
/** **************************************************************************
 * \n \brief Routine receive a byte of data from uart.
 *
 * This routine receive a byte of data from uart.This routine takes uart id  as 
 * a parameter which gives information about which uart to be selected along with 
 * that it takes bufferpointer as another parameter to copy the received data 
 * and timeout as another parameter.
 *
 * \param   uart		 [IN]     uart to be selected
 * \param   *rx          [IN]     Buffer pointer to copy received data 
 * \param   timeout      [IN]     Timeout for receiving  
 *                                                                
 * \return        
 * \n        returns 1 on failure                                        
 * \n        returns 0 on success
 *  
 * 
 */
INT16 uart_recv( UART_Handle uart, UINT8* rx, INT32 timeout )
{
    /* Check if RX ready, if not timeout */
    while( _UART_rcvReady( uart ) == 0 )
    {
    	
          if ( timeout-- < 0 )
          {
              printf("Error:Timeout occured while Receiving\n");
              return 1;
          }    
    }  
    
    /* Read 1 byte */
    _UART_getChar( uart, rx );
    return 0;
}
/** **************************************************************************
 * \n \brief Routine send a byte of data to uart.
 *
 * This routine send a byte of data to uart.This routine takes uart id as 
 * a parameter which gives information about which uart to be selected along with 
 * that it takes buffer pointer as another parameter to send  data 
 * and timeout as another parameter.
 *
 * \param   uart	    [IN]    uart to be selected
 * \param   tx          [IN]    Data to be transmitted 
 * \param   timeout     [IN]    Timeout for transmitting
 *                                                                
 * \return        
 * \n        returns 1 on failure                                        
 * \n        returns 0 on success
 *  
 * 
 */
INT16 uart_send( UART_Handle uart, UINT8 tx, INT32 timeout )
{
    /* Check if TX ready, if not timeout */
    while( _UART_xmtReady( uart ) == 0 )
    {
    	
        if ( timeout-- < 0 )
        {
           printf("Error:Timeout occured while transmitting\n");
           return 1;
        }   
    
    }  
    
    /* Write 1 byte */
   _UART_putChar( uart, tx );
    
    return 0;    
}
#endif

 /** **************************************************************************
 * \n \brief Routine to do uart_loopback_test
 *
 * This routine does uart_loopback_test.This routine transmits a buffer of size  
 * 256 bytes and receives the same and compares both the buffer .Returns 0 on
 * success.
 * 
 * \return        
 * \n        returns Non-Zero value on failure                                        
 * \n        returns zero success
 *  
 * 
 */

STATUS uart_loopback_test( )
{
    SINT16 i;
    SINT16 errors = 0;
static UINT8 Px[45] = "\r\nEnter the 20 character Hera \r\n";
static UINT8 tx[256] = { };
static UINT16 len;
static SINT32 uart_timeout ;

	uart_timeout = (0x000A0000);
    len = 20;

    UART_Handle uart0;


    /* Open Uart Handle */
    if ( ( uart0 = _UART_open( UART_0, /*115200*/ 26 ) ) == 0 )
        return -1;

    printf("\r\n Enter the character in the serial terminal \r\n");
    len = strlen((const char *)"\r\nEnter the character up to 20 char \r\n");
      for(i= 0; i < len; i++)
      {
      	 uart_send( uart0, Px[i], uart_timeout );
      }

    for ( i = 0 ; i < len ; i++ )
        tx[i] = 0;
    len = 20;

    /* UART Test */
    for ( i = 0 ; i < len ; i++ )
    {

    	 if ( uart_recv( uart0, &tx[i], uart_timeout ) )  // RX
    		 platform_write("\nfailed to recv");

        if(  uart_send( uart0, tx[i], uart_timeout ))   // TX
        	platform_write("\nfailed to send");
        /* Increase the timeout  0x00A00000*/
    }

    Uart_stringSend("\r\n-------------------------X-----------------------------");
    return errors;

}
